<?php
/**
 * 404 page
 *
 * @package consultpress-pt
 */

get_header();

?>

<div id="primary" class="content-area  error-404  container">
	<div class="row">
		<main id="main" class="site-main  js-main  col-xs-12  col-lg-9">
			<p class="h2  error-404__subtitle"><?php esc_html_e( 'You landed on the wrong side of the page!' , 'consultpress-pt' ); ?></p>
			<p class="error-404__text">
			<?php
				printf(
					/* translators: the first %s for line break, the second and third %s for link to home page wrap */
					esc_html__( 'Page you are looking for is not here. %1$s Go %2$sHome%3$s or try to search:' , 'consultpress-pt' ),
					'<br>',
					'<b><a href="' . esc_url( home_url( '/' ) ) . '">',
					'</a></b>'
				);
			?>
			</p>
			<div class="widget_search">
				<?php get_search_form(); ?>
			</div>
		</main>

		<div class="col-xs-12  col-lg-3 <?php echo has_nav_menu( 'main-menu' ) ? ' hidden-lg-up' : ''; ?>">
			<div class="sidebar  sidebar--static">
				<?php dynamic_sidebar( apply_filters( 'consultpress_regular_page_sidebar', 'regular-page-sidebar', get_the_ID() ) ); ?>
			</div>
		</div>
	</div>
</div>

<div class="hidden-md-down">
	<div class="hovercraft  js-hovercraft">
		<!-- Header widget area -->
		<?php get_template_part( 'template-parts/header-widget-area' ); ?>
		<!-- Featured Button -->
		<?php get_template_part( 'template-parts/featured-button' ); ?>
	</div>
	<?php if ( has_nav_menu( 'main-menu' ) ) : ?>
		<div class="sidebar  sidebar--sticky  js-sidebar">
			<!-- Main Navigation -->
			<?php get_template_part( 'template-parts/main-navigation' ); ?>
			<!-- Sidebar -->
			<?php dynamic_sidebar( apply_filters( 'consultpress_regular_page_sidebar', 'regular-page-sidebar', get_the_ID() ) ); ?>
		</div>
	<?php endif; ?>
</div>

<?php get_footer(); ?>
