/**
 * Sidebar position
 * Source: twentyfifteen, js/functions.js
 */
define( [ 'jquery', 'underscore' ], function ( $, _ ) {
	'use strict';

	var $body, bodyHeight,
	    $footer, footerHeight,
	    $window, windowHeight,
	    $sidebar, sidebarHeight,
	    $mainContent,
	    top = false, bottom = false,
	    windowPos, lastWindowPos = 0,
	    overTop = false, overBottom = false;

	function updateVars() {
		sidebarHeight = $sidebar.height();
		windowHeight  = $window.height();
		bodyHeight    = $body.height();
		footerHeight  = $footer.outerHeight();
	}

	// Sidebar scrolling.
	function resize() {
		if ( Modernizr.mq( '(min-width: 992px)' ) ) { // set minimum height of the main content
			sidebarHeight = $sidebar.height();
			$mainContent.css( 'min-height', ( getMinimumTopSpacingOfSidebar() + sidebarHeight - $mainContent.offset().top ) );
		} else {
			top = bottom = overTop = overBottom = false;
			$sidebar.removeAttr( 'style' );
			$mainContent.removeAttr( 'style' );
		}
	}

	function scroll() {
		windowPos = $window.scrollTop();

		if ( ! Modernizr.mq( '(min-width: 992px)' ) ) {
			return;
		}

		updateVars();

		if ( sidebarHeight > getScrollableViewportHeight() ) {
			if ( windowPos > lastWindowPos ) { // scroll down
				if ( overTop && ! isScrollOverTop() ) {
					overTop = false;
				}

				if ( top ) {
					top = false;
					$sidebar.attr( 'style', 'position: absolute; top: ' + $sidebar.offset().top + 'px;' );
				} else if ( ! bottom && windowPos + windowHeight > sidebarHeight + $sidebar.offset().top && ! overBottom ) {
					bottom = true;
					$sidebar.attr( 'style', 'position: fixed; bottom: 0;' );
				} else if ( bottom && ! overBottom && isScrollOverBottom() ) {
					overBottom = true;
					$sidebar.attr( 'style', 'position: absolute; top: ' + ( bodyHeight - footerHeight - sidebarHeight ) + 'px;' );
				}
			} else if ( windowPos < lastWindowPos ) { // scroll up
				if ( overBottom && ! isScrollOverBottom() ) {
					overBottom = false;
				}

				if ( bottom ) {
					bottom = false;
					$sidebar.attr( 'style', 'position: absolute; top: ' + $sidebar.offset().top + 'px;' );
				} else if ( ! top && windowPos + getUnscrollableTopHeight() < $sidebar.offset().top && ! overTop ) {
					top = true;
					$sidebar.attr( 'style', 'position: fixed; top: ' + getUnscrollableTopHeight() + 'px;' );
				} else if ( top && ! overTop && isScrollOverTop() ) {
					overTop = true;
					$sidebar.attr( 'style', 'position: absolute; top: ' + getMinimumTopSpacingOfSidebar() + 'px;' );
				}
			} else if ( ! overBottom ) { // actually init
				top = bottom = false;
				$sidebar.attr( 'style', 'position: absolute; top: ' + getMinimumTopSpacingOfSidebar() + 'px;' );
			}
		} else { // sidebar shorter than window height
			if ( windowPos + getUnscrollableTopHeight() < getMinimumTopSpacingOfSidebar() ) {
				$sidebar.attr( 'style', 'position: absolute; top: ' + getMinimumTopSpacingOfSidebar() + 'px;' );
			} else if ( windowPos + getUnscrollableTopHeight() + sidebarHeight > bodyHeight - footerHeight ) {
				$sidebar.attr( 'style', 'position: absolute; top: ' + ( bodyHeight - footerHeight - sidebarHeight ) + 'px;' );
			} else {
				overTop = false;
				$sidebar.attr( 'style', 'position: fixed; top: ' + getUnscrollableTopHeight() + 'px;' );
			}
		}

		lastWindowPos = windowPos;
	}

	function resizeAndScroll() {
		resize();
		scroll();
	}

	function getMinimumTopSpacingOfSidebar() {
		return ( $( '.js-hovercraft' ).first().outerHeight( true ) + getUnscrollableTopHeight() );
	}

	function getScrollableViewportHeight() {
		return ( windowHeight - getUnscrollableTopHeight() );
	}

	function getUnscrollableTopHeight() {
		return parseInt( $( 'html' ).css( 'marginTop' ) );
	}

	function isScrollOverBottom() {
		return ( windowPos + windowHeight > bodyHeight - footerHeight );
	}

	function isScrollOverTop() {
		return ( windowPos + getUnscrollableTopHeight() < getMinimumTopSpacingOfSidebar() );
	}

	$( document ).ready( function() {
		$body        = $( document.body );
		$footer      = $( '.js-footer' ).first();
		$window      = $( window );
		$sidebar     = $( '.js-sidebar' ).first();
		$mainContent = $( '.js-main' ).first();

		$window
			.on( 'scroll.stickySidebar', _.throttle( scroll, 16 ) )
			.on( 'resize.stickySidebar', _.debounce( resizeAndScroll, 500 ) );

		resizeAndScroll();

		// preview bar toggle
		$( 'body' ).on( 'pt_pb_toggle', function () {
			setTimeout( function () {
				scroll();
			}, 210 );
		} );
	} );

} );
