/* global ConsultPressVars */

// config
require.config( {
	paths: {
		jquery:          'assets/js/fix.jquery',
		underscore:      'assets/js/fix.underscore',
		util:            'bower_components/bootstrap/js/dist/util',
		alert:           'bower_components/bootstrap/js/dist/alert',
		button:          'bower_components/bootstrap/js/dist/button',
		carousel:        'bower_components/bootstrap/js/dist/carousel',
		collapse:        'bower_components/bootstrap/js/dist/collapse',
		dropdown:        'bower_components/bootstrap/js/dist/dropdown',
		modal:           'bower_components/bootstrap/js/dist/modal',
		scrollspy:       'bower_components/bootstrap/js/dist/scrollspy',
		tab:             'bower_components/bootstrap/js/dist/tab',
		tooltip:         'bower_components/bootstrap/js/dist/tooltip',
		popover:         'bower_components/bootstrap/js/dist/popover',
		SlickCarousel:   'bower_components/slick-carousel/slick/slick',
		isElementInView: 'assets/js/utils/isElementInView',
		stampit:         'assets/js/vendor/stampit',
	}
} );

require.config( {
	baseUrl: ConsultPressVars.pathToTheme
} );

require( [
		'jquery',
		'underscore',
		'isElementInView',
		'assets/js/utils/objectFitFallback',
		'assets/js/utils/easeInOutQuad',
		'vendor/proteusthemes/proteuswidgets/assets/js/NumberCounter',
		'assets/js/theme-slider/slick-carousel',
		'assets/js/theme-slider/vimeo-events',
		'assets/js/theme-slider/youtube-events',
		'assets/js/StickySidebar',
		'assets/js/TouchDropdown',
		'SlickCarousel',
		'util',
		'carousel',
		'collapse',
		'tab',
		'modal',
], function ( $, _, isElementInView, objectFitFallback, easeInOutQuad, NumberCounter, ThemeSlider, VimeoEvents, YoutubeEvents ) {
	'use strict';

	/**
	 * Footer widgets fix
	 */
	$( '.col-lg-__col-num__' ).removeClass( 'col-lg-__col-num__' ).addClass( 'col-lg-3' );

	/**
	 * Number Counter Widget JS code
	 */
	// Get all number counter widgets
	var $counterWidgets = $( '.number-counters' );

	if ( $counterWidgets.length ) {

		// jQuery easing function: easeInOutQuad, for use in NumberCounter
		easeInOutQuad();

		$counterWidgets.each( function () {
			new NumberCounter( $( this ) );
		} );
	}

	/**
	 * Slick carousel for the Person profile widget (from the PW composer package).
	 */
	$( '.js-person-profile-initialize-carousel' ).slick();

	/**
	 * Slick Carousel - Theme Slider
	 */
	(function () {
		var themeSliderInstance = new ThemeSlider( $( '.js-pt-slick-carousel-initialize-slides' ) );
		new VimeoEvents( themeSliderInstance );
		new YoutubeEvents( themeSliderInstance );
	})();

	/**
	 * Animate the scroll, when back to top is clicked
	 */
	( function () {
		$( '.js-back-to-top' ).click( function ( ev ) {
			ev.preventDefault();

			$( 'body, html' ).animate( {
				scrollTop: 0
			}, 700 );
		});
	} )();

	/**
	 * Object fit - fallback for old browsers
	 * @return {[type]} [description]
	 */
	(function () {
		if ( ! Modernizr.objectfit ) {
			// slider, page header (single, portfoliop)
			$('.js-object-fit-fallback').each(function () {
				objectFitFallback({
					$container: $( this )
				});
			});
		}
	}());

	/**
	 * Open position change text for the read more/close link.
	 */
	(function () {
		$( document ).on( 'shown.bs.collapse', '.js-open-position-collapse', function() {
			$( this ).parent().find( '.js-open-position-read-more-link' ).text( ConsultPressVars.close );
		});

		$( document ).on( 'hidden.bs.collapse', '.js-open-position-collapse', function() {
			$( this ).parent().find( '.js-open-position-read-more-link' ).text( ConsultPressVars.learn_more );
		});
	}());
});
