<?php
/**
 * Footer
 *
 * @package consultpress-pt
 */

$consultpress_footer_widgets_layout = ConsultPressHelpers::footer_widgets_layout_array();

// Bottom footer texts.
$consultpress_footer_bottom_txt   = get_theme_mod( 'footer_bottom_txt', '&copy; ' . date( 'Y' ) . ' <strong><a href="https://www.proteusthemes.com/wordpress-themes/consultpress/">ConsultPress</a></strong> All Rights Reserved.' );
$consultpress_footer_featured_txt = get_theme_mod( 'footer_featured_text', '' );

?>

	<footer class="footer__container  js-footer">
		<div class="container">
			<div class="footer">
				<?php if ( ! empty( $consultpress_footer_featured_txt ) ) : ?>
					<div class="footer__featured">
						<?php echo wp_kses_post( do_shortcode( $consultpress_footer_featured_txt ) ); ?>
					</div>
				<?php endif; ?>
				<div class="footer__content<?php echo ( ! empty( $consultpress_footer_widgets_layout ) && is_active_sidebar( 'footer-widgets' ) ) ? '' : '  footer__content--no-widgets'; ?>">
					<?php if ( ! empty( $consultpress_footer_widgets_layout ) && is_active_sidebar( 'footer-widgets' ) ) : ?>
						<div class="footer-top">
							<div class="row">
								<?php dynamic_sidebar( 'footer-widgets' ); ?>
							</div>
						</div>
					<?php endif; ?>
					<div class="footer-bottom">
						<?php if ( ! empty( $consultpress_footer_bottom_txt ) ) : ?>
							<div class="footer-bottom__text">
								<?php echo wp_kses_post( do_shortcode( $consultpress_footer_bottom_txt ) ); ?>
							</div>
						<?php endif; ?>
						<a class="footer-bottom__back-to-top  js-back-to-top" href="#"><span class="hidden-lg-up"><?php esc_html_e( 'Back to Top', 'consultpress-pt' ); ?></span> <i class="fa fa-long-arrow-up" aria-hidden="true"></i></a>
					</div>
				</div>
			</div>
		</div>
	</footer>
	</div><!-- end of .boxed-container -->

	<?php wp_footer(); ?>
	</body>
</html>
