<?php
/**
 * The Header for ConsultPress Theme
 *
 * @package consultpress-pt
 */

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0" />
		<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
		<?php endif; ?>

		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>
	<div class="boxed-container<?php echo ( is_single() && 'post' === get_post_type() ) ? '  h-entry' : ''; ?>">

	<header class="header__container">
		<div class="container">
			<div class="header">
				<div class="container">
					<!-- Logo -->
					<?php
						$consultpress_logo   = get_theme_mod( 'logo_img', false );
						$consultpress_logo2x = get_theme_mod( 'logo2x_img', false );
					?>
					<a class="header__logo<?php echo empty( $consultpress_logo ) ? '  header__logo--text' : ''; ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">
						<?php if ( ! empty( $consultpress_logo ) ) : ?>
							<img src="<?php echo esc_url( $consultpress_logo ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>" srcset="<?php echo esc_attr( $consultpress_logo ); ?><?php echo empty( $consultpress_logo2x ) ? '' : ', ' . esc_url( $consultpress_logo2x ) . ' 2x'; ?>" class="img-fluid" <?php echo ConsultPressHelpers::get_logo_dimensions(); ?> />
						<?php
						else :
							printf( '<%1$s class="h1  header__logo-text">%2$s</%1$s>', ConsultPressHelpers::is_slider_template() ? 'h1' : 'p', esc_html( get_bloginfo( 'name' ) ) );
						endif;
						?>
					</a>
					<!-- Only on mobile Header Widgets -->
					<?php if ( is_active_sidebar( 'header-widgets' ) ) : ?>
						<div class="sidebar__header-widgets  header-widgets  hidden-lg-up">
							<?php dynamic_sidebar( apply_filters( 'consultpress_header_widgets', 'header-widgets', get_the_ID() ) ); ?>
						</div>
					<?php endif; ?>
					<!-- Only on mobile Featured Button -->
					<?php
						$featured_page_data = ConsultPressHelpers::get_featured_page_data();

						if ( ! empty( $featured_page_data ) ) :
					?>
						<a class="btn  btn-primary  btn-block  btn-featured  hidden-lg-up" href="<?php echo esc_url( $featured_page_data['url'] ); ?>" target="<?php echo esc_attr( $featured_page_data['target'] ); ?>"><?php echo esc_html( $featured_page_data['title'] ); ?></a>
					<?php endif; ?>
					<!-- Toggle button for Main Navigation on mobile -->
					<button class="btn  btn-dark  btn-block  header__navbar-toggler  hidden-lg-up  js-sticky-mobile-option" type="button" data-toggle="collapse" data-target="#consultpress-main-navigation"><i class="fa  fa-bars  hamburger"></i> <span><?php esc_html_e( 'MENU' , 'consultpress-pt' ); ?></span></button>
					<!-- Only on mobile Main Navigation -->
					<nav class="sidebar__main-navigation  collapse  navbar-toggleable-md  js-sticky-desktop-option  hidden-lg-up" id="consultpress-main-navigation" aria-label="<?php esc_html_e( 'Main Menu', 'consultpress-pt' ); ?>">
						<?php
						if ( has_nav_menu( 'main-menu' ) ) {
							wp_nav_menu( array(
								'theme_location' => 'main-menu',
								'container'      => false,
								'menu_class'     => 'main-navigation  js-main-nav  js-dropdown',
								'walker'         => new Aria_Walker_Nav_Menu(),
								'items_wrap'     => '<ul id="%1$s" class="%2$s" role="menubar">%3$s</ul>',
							) );
						}
						?>

						<!-- Social Icons -->
						<?php
						if ( has_nav_menu( 'main-menu' ) ) {
							get_template_part( 'template-parts/header-social-icons' );
						}
						?>
					</nav>
				</div>
				<!-- Page Header -->
				<?php
				if ( ! is_page_template( 'template-front-page-slider.php' || 'template-front-page-slider-alt.php' ) ) {
					get_template_part( 'template-parts/page-header' );
				}
				?>
			</div>
		</div>
	</header>
