<?php
/**
 * Compatibility hooks
 *
 * For 3rd party plugins/features.
 *
 * @package consultpress-pt
 */

/**
 * ConsultPressCompat class with compatibility hooks
 */
class ConsultPressCompat {

	/**
	 * Runs on class initialization. Adds actions and filters.
	 */
	function __construct() {
		add_action( 'activate_breadcrumb-navxt/breadcrumb-navxt.php', array( $this, 'custom_hseparator' ) );
	}

	/**
	 * Set custom separator for NavXT breadcrumbs plugin.
	 */
	function custom_hseparator() {
		add_option( 'bcn_options', array( 'hseparator' => '' ) );
	}
}

// Single instance.
$consultpress_compat = new ConsultPressCompat();
