<?php
/**
 * Class which handles the output of the WP customizer on the frontend.
 * Meaning that this stuff loads always, no matter if the global $wp_cutomize
 * variable is present or not.
 *
 * @package consultpress-pt
 */

/**
 * Customizer frontend related code
 */
class ConsultPress_Customize_Frontent {

	/**
	 * Add actions to load the right staff at the right places (header, footer).
	 */
	function __construct() {
		add_action( 'wp_enqueue_scripts' , array( $this, 'output_customizer_css' ), 20 );
		add_action( 'wp_head' , array( $this, 'head_output' ) );
		add_action( 'wp_footer' , array( $this, 'footer_output' ) );
	}

	/**
	 * This will output the custom WordPress settings to the live theme's WP head.
	 *
	 * Used by hook: 'wp_head'
	 *
	 * @see add_action( 'wp_head' , array( $this, 'head_output' ) );
	 */
	public static function output_customizer_css() {
		$css_string = self::get_customizer_css();

		if ( $css_string ) {
			wp_add_inline_style( 'consultpress-main', $css_string );
		}
	}

	/**
	 * This will get custom WordPress settings to the live theme's WP head.
	 *
	 * Used by hook: 'wp_head'
	 *
	 * @see add_action( 'wp_head' , array( $this, 'head_output' ) );
	 */
	public static function get_customizer_css() {
		$css = array();

		$css[] = self::get_customizer_colors_css();
		$css[] = self::get_logo_top_margin_css();
		$css[] = self::get_page_header_bg_image();
		$css[] = self::get_body_bg_image();

		return join( PHP_EOL, $css );
	}


	/**
	 * Branding CSS, generated dynamically and cached stringifyed in db
	 *
	 * @return string CSS
	 */
	public static function get_customizer_colors_css() {
		$out = '';

		$cached_css = get_theme_mod( 'cached_css', '' );

		$out .= '/* WP Customizer start */' . PHP_EOL;
		$out .= apply_filters( 'consultpress_cached_css', $cached_css );
		$out .= PHP_EOL . '/* WP Customizer end */';

		return $out;
	}


	/**
	 * Page header background image
	 *
	 * @return string CSS
	 */
	public static function get_page_header_bg_image() {
		// Don't output header bg CSS on Front Page with Slider page template.
		if ( is_page_template( array( 'template-front-page-slider.php', 'template-front-page-slider-alt.php' ) ) ) {
			return '';
		}

		$out                           = '';
		$page_header_bg_img            = get_theme_mod( 'page_header_bg_img', '' );
		$page_header_bg_img_repeat     = get_theme_mod( 'page_header_bg_img_repeat', 'repeat' );
		$page_header_bg_img_position_x = get_theme_mod( 'page_header_bg_img_position_x', 'left' );
		$page_header_bg_img_attachment = get_theme_mod( 'page_header_bg_img_attachment', 'scroll' );

		if ( '' !== $page_header_bg_img ) {
			$out = '@media (max-width: 991px) {';
			$out .= ' .header__page-header {';
			$out .= "  background-image: url('$page_header_bg_img');";
			$out .= "  background-repeat: $page_header_bg_img_repeat;";
			$out .= "  background-position: top $page_header_bg_img_position_x;";
			$out .= "  background-attachment: $page_header_bg_img_attachment;";
			$out .= ' }';
			$out .= '}';

			$out .= '@media (min-width: 992px) {';
			$out .= ' .header__container {';
			$out .= "  background-image: url('$page_header_bg_img');";
			$out .= "  background-repeat: $page_header_bg_img_repeat;";
			$out .= "  background-position: top $page_header_bg_img_position_x;";
			$out .= "  background-attachment: $page_header_bg_img_attachment;";
			$out .= ' }';
			$out .= '}';
		}

		return $out;
	}


	/**
	 * Body background image
	 *
	 * @return string CSS
	 */
	public static function get_body_bg_image() {
		$out                    = '';
		$body_bg_img            = get_theme_mod( 'body_bg_img', '' );
		$body_bg_img_repeat     = get_theme_mod( 'body_bg_img_repeat', 'repeat' );
		$body_bg_img_position_x = get_theme_mod( 'body_bg_img_position_x', 'left' );
		$body_bg_img_attachment = get_theme_mod( 'body_bg_img_attachment', 'scroll' );

		if ( ! empty( $body_bg_img ) ) {
			$out = 'body .boxed-container {';
			$out .= " background-image: url('$body_bg_img');";
			$out .= " background-repeat: $body_bg_img_repeat;";
			$out .= " background-position: top $body_bg_img_position_x;";
			$out .= " background-attachment: $body_bg_img_attachment;";
			$out .= '}';
		}

		return $out;
	}


	/**
	 * Set top margin of the logo
	 *
	 * @return string CSS
	 */
	public static function get_logo_top_margin_css() {
		// Pixel to rem conversion.
		$rem_pt_ratio = 18;
		$rem = absint( get_theme_mod( 'logo_top_margin', 0 ) ) / $rem_pt_ratio;

		return sprintf(
			'.header__logo img { margin-top: %frem; }',
			$rem
		);
	}


	/**
	 * Outputs the code in head of the every page
	 *
	 * Used by hook: add_action( 'wp_head' , array( $this, 'head_output' ) );
	 */
	public static function head_output() {
		// Custom JS from the customizer.
		$script = get_theme_mod( 'custom_js_head', '' );

		if ( ! empty( $script ) ) {
			echo PHP_EOL . $script . PHP_EOL;
		}
	}


	/**
	 * Outputs the code in footer of the every page, right before closing </body>
	 *
	 * Used by hook: add_action( 'wp_footer' , array( $this, 'footer_output' ) );
	 */
	public static function footer_output() {
		$script = get_theme_mod( 'custom_js_footer', '' );

		if ( ! empty( $script ) ) {
			echo PHP_EOL . $script . PHP_EOL;
		}
	}
}
