<?php
/**
 * Add the link to documentation under Appearance in the wp-admin
 *
 * @package consultpress-pt
 */

if ( ! function_exists( 'consultpress_add_docs_page' ) ) {

	/**
	 * Creates the Documentation page under the Appearance menu in wp-admin.
	 */
	function consultpress_add_docs_page() {
		add_theme_page(
			esc_html__( 'Documentation', 'consultpress-pt' ),
			esc_html__( 'Documentation', 'consultpress-pt' ),
			'',
			'proteusthemes-theme-docs',
			'consultpress_docs_page_output'
		);
	}
	add_action( 'admin_menu', 'consultpress_add_docs_page' );

	/**
	 * This is the callback function for the Documentation page above.
	 * This is the output of the Documentation page.
	 */
	function consultpress_docs_page_output() {
		?>
		<div class="wrap">
			<h2><?php esc_html_e( 'Documentation', 'consultpress-pt' ); ?></h2>

			<p>
				<strong><a href="https://www.proteusthemes.com/docs/consultpress/" class="button button-primary " target="_blank"><?php esc_html_e( 'Click here to see online documentation of the theme!', 'consultpress-pt' ); ?></a></strong>
			</p>
		</div>
		<?php
	}
}
