<?php

/*
Widget Name: Open Position
Description: Widget for displaying job offers in Page Builder.
Author: ProteusThemes
Author URI: https://www.proteusthemes.com
*/

class PW_Open_Position extends SiteOrigin_Widget {

	function __construct() {

		// Call the parent constructor with the required arguments.
		parent::__construct(
			// The unique id for your widget.
			'pw_open_position',
			// The name of the widget for display purposes.
			sprintf( 'ProteusThemes: %s', esc_html__( 'Open Position', 'consultpress-pt' ) ),
			// The $widget_options array, which is passed through to WP_Widget.
			// It has a couple of extras like the optional help URL, which should link to your sites help or support page.
			array(
				'description' => esc_html__( 'Widget for displaying job offers in Page Builder.', 'consultpress-pt' ),
				'classname'   => 'widget-open-position',
			),
			// The $control_options array, which is passed through to WP_Widget.
			array(),
			// The $form_options array, which describes the form fields used to configure SiteOrigin widgets.
			array(
				'title' => array(
					'type'  => 'text',
					'label' => esc_html__( 'Title', 'consultpress-pt' ),
				),
				'date' => array(
					'type'  => 'text',
					'label' => esc_html__( 'Date', 'consultpress-pt' ),
				),
				'location' => array(
					'type'  => 'text',
					'label' => esc_html__( 'Location', 'consultpress-pt' ),
				),
				'content' => array(
					'type'  => 'tinymce',
					'label' => esc_html__( 'Content', 'consultpress-pt' ),
				),
				'details_title' => array(
					'type'  => 'text',
					'label' => esc_html__( 'Details Title', 'consultpress-pt' ),
				),
				'detail_items' => array(
					'type'      => 'repeater',
					'label'     => esc_html__( 'Detail Items', 'consultpress-pt' ),
					'item_name' => esc_html__( 'Item', 'consultpress-pt' ),
					'fields'    => array(
						'icon' => array(
							'type'  => 'icon',
							'label' => esc_html__( 'Icon', 'consultpress-pt' ),
						),
						'text' => array(
							'type'  => 'text',
							'label' => esc_html__( 'Text', 'consultpress-pt' ),
						),
					),
				),
			),
			plugin_dir_path( __FILE__ )
		);
	}

	function get_template_name( $instance ) {
		return 'open-position-template';
	}

	function get_style_name( $instance ) {
		return '';
	}
}

siteorigin_widget_register( 'open-position', __FILE__, 'PW_Open_Position' );
