<?php
/**
 * Load the Customizer with some custom extended addons
 *
 * @package consultpress-pt
 * @link http://codex.wordpress.org/Theme_Customization_API
 */

/**
 * Require kirki (enhanced customizer controls).
 */
require_once trailingslashit( get_template_directory() ) . 'vendor/kirki/kirki.php';

/**
 * This funtion is only called when the user is actually on the customizer page
 *
 * @param  WP_Customize_Manager $wp_customize
 */
if ( ! function_exists( 'consultpress_customizer' ) ) {
	function consultpress_customizer( $wp_customize ) {
		// Add required files.
		ConsultPressHelpers::load_file( '/inc/customizer/class-customize-base.php' );

		new ConsultPress_Customizer_Base( $wp_customize );
	}
	add_action( 'customize_register', 'consultpress_customizer' );
}


/**
 * Takes care for the frontend output from the customizer and nothing else
 */
if ( ! function_exists( 'consultpress_customizer_frontend' ) && ! class_exists( 'ConsultPress_Customize_Frontent' ) ) {
	function consultpress_customizer_frontend() {
		ConsultPressHelpers::load_file( '/inc/customizer/class-customize-frontend.php' );
		$consultpress_customize_frontent = new ConsultPress_Customize_Frontent();
	}
	add_action( 'init', 'consultpress_customizer_frontend' );
}
