<?php echo $args['before_widget']; ?>

	<div class="person-profile  h-card">
		<?php if ( ! empty( $instance['image'] ) ) : ?>
		<img class="person-profile__image  wp-post-image" src="<?php echo esc_url( $instance['image'] ); ?>" alt="<?php echo esc_attr( $text['picture_of'] ) . ' ' . esc_attr( $instance['name'] ); ?>">
		<?php endif; ?>
		<?php if ( ! empty( $instance['carousel'] ) ) : ?>
			<?php
				// Parameters for the slick carousel slider.
				$slick_data = array(
					'adaptiveHeight' => true,
					'fade'           => true,
					'prevArrow'      => '<button type="button" class="slick-prev  slick-arrow"><span class="screen-reader-text">' . esc_html__( 'Previous', 'consultpress-pt' ) . '</span><i class="fa fa-long-arrow-down" aria-hidden="true"></i></button>',
					'nextArrow'      => '<button type="button" class="slick-next  slick-arrow"><span class="screen-reader-text">' . esc_html__( 'Next', 'consultpress-pt' ) . '</span><i class="fa fa-long-arrow-up" aria-hidden="true"></i></button>',
				);
			?>
			<div class="person-profile__carousel<?php echo 1 < count( $instance['carousel'] ) ? '  js-person-profile-initialize-carousel' : ''; ?>" <?php echo 1 < count( $instance['carousel'] ) ? "data-slick='" . wp_json_encode( $slick_data ) . "'" : ""; ?>>
				<?php foreach ( $instance['carousel'] as $carousel_item ) : ?>
					<div class="person-profile__carousel-item">
						<?php if ( 'image' === $carousel_item['type'] && ! empty( $carousel_item['url'] ) ) : ?>
							<img class="person-profile__image  wp-post-image  u-photo" src="<?php echo esc_url( $carousel_item['url'] ); ?>" alt="<?php echo esc_attr( $text['picture_of'] ) . ' ' . esc_attr( $instance['name'] ); ?>">
						<?php elseif ( 'video' === $carousel_item['type'] && ! empty( $carousel_item['url'] ) ) : ?>
							<?php
								$video_class = '';
								if ( strstr( $carousel_item['url'], 'youtube.com/' ) ) {
									$video_class = '  js-carousel-item-yt-video';
								}
								elseif ( strstr( $carousel_item['url'], 'vimeo.com/' ) ) {
									$video_class = '  js-carousel-item-vimeo-video';
								}
							?>
							<div class="person-profile__carousel-item--video<?php echo esc_attr( $video_class ); ?>">
								<?php
									echo wp_oembed_get(
										esc_url( $carousel_item['url'] ),
										array(
											'api' => '1',
											'player_id' => uniqid( 'pt-sc-pp-video-' ),
										)
									);
								?>
							</div>
						<?php endif; ?>
					</div>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>
		<div class="person-profile__container">
			<div class="person-profile__content">
				<?php if ( ! empty( $instance['label'] ) && ! empty( $instance['carousel'] ) ) : ?>
					<span class="person-profile__label  p-label"><?php echo esc_html( $instance['label'] ); ?></span>
				<?php endif; ?>
				<h4 class="person-profile__name  p-name"><?php echo esc_html( $instance['name'] ); ?></h4>
				<p class="person-profile__description"><?php echo wp_kses_post( $instance['description'] ); ?></p>
				<?php if ( ! empty( $instance['tags'] ) ) : ?>
					<div class="person-profile__tags">
						<?php foreach ( $instance['tags'] as $tag ) : ?>
							<div class="person-profile__tag">
								<?php echo esc_html( $tag ); ?>
							</div>
					<?php endforeach; ?>
					</div>
				<?php endif; ?>
			</div>
			<?php if ( ! empty( $instance['social_icons'] ) ) : ?>
				<div class="person-profile__social-icons">
					<?php foreach ( $instance['social_icons'] as $icon ) : ?>
						<a class="person-profile__social-icon" href="<?php echo esc_url( $icon['link'] ); ?>" target="<?php echo ( ! empty( $instance['new_tab'] ) ) ? '_blank' : '_self' ?>"><i class="fa  <?php echo esc_attr( $icon['icon'] ); ?>"></i></a>
					<?php endforeach; ?>
				</div>
			<?php endif; ?>
		</div>
	</div>

<?php echo $args['after_widget']; ?>
