<?php
/**
 * The template for displaying all single posts.
 *
 * @package consultpress-pt
 */

get_header(); ?>

	<div id="primary" class="content-area  container">
		<div class="row">
			<main id="main" class="site-main  js-main  col-xs-12  col-lg-9">
				<?php get_template_part( 'template-parts/breadcrumbs' ); ?>

				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'template-parts/content', 'single' ); ?>

					<?php
					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) {
						comments_template();
					}
					?>

				<?php endwhile; // End of the loop. ?>
			</main>

			<div class="col-xs-12  col-lg-3 <?php echo has_nav_menu( 'main-menu' ) ? ' hidden-lg-up' : ''; ?>">
				<div class="sidebar  sidebar--static">
					<?php dynamic_sidebar( apply_filters( 'consultpress_blog_sidebar', 'blog-sidebar', get_the_ID() ) ); ?>
				</div>
			</div>
		</div>
	</div><!-- #primary -->

	<div class="hidden-md-down">
		<div class="hovercraft  js-hovercraft">
			<!-- Header widget area -->
			<?php get_template_part( 'template-parts/header-widget-area' ); ?>
			<!-- Featured Button -->
			<?php get_template_part( 'template-parts/featured-button' ); ?>
		</div>
		<?php if ( has_nav_menu( 'main-menu' ) ) : ?>
			<div class="sidebar  sidebar--sticky  js-sidebar">
				<!-- Main Navigation -->
				<?php get_template_part( 'template-parts/main-navigation' ); ?>
				<!-- Sidebar -->
				<?php dynamic_sidebar( apply_filters( 'consultpress_blog_sidebar', 'blog-sidebar', get_the_ID() ) ); ?>
			</div>
		<?php endif; ?>
	</div>

<?php get_footer(); ?>
