<?php
/**
 * Header Social Icons.
 *
 * @package consultpress-pt
 */

// Get social icons from the customizer repeater field.
$consultpress_social_icons = get_theme_mod( 'navigation_social_icons', array(
	array(
		'icon' => 'fa-linkedin',
		'url'  => 'https://www.linkedin.com',
	),
	array(
		'icon' => 'fa-facebook',
		'url'  => 'https://www.facebook.com/ProteusThemes',
	),
	array(
		'icon' => 'fa-twitter',
		'url'  => 'https://twitter.com/ProteusThemes',
	),
) );

// Get social icons intro text.
$consultpress_social_icons_intro_text = get_theme_mod( 'navigation_social_icons_intro_text', 'Get social with us:' );
?>

<?php if ( ! empty( $consultpress_social_icons ) ) : ?>
<div class="social-icons">
	<p class="social-icons__text"><?php echo esc_html( $consultpress_social_icons_intro_text ); ?></p>
	<?php foreach ( $consultpress_social_icons as $item ) : ?>
		<a class="social-icons__link" href="<?php echo esc_url( $item['url'] ); ?>" target="_blank"><i class="fa  <?php echo esc_attr( $item['icon'] ); ?>"></i></a>
	<?php endforeach; ?>
</div>
<?php endif; ?>
