<?php
/**
 * The page title part of the header
 *
 * @package consultpress-pt
 */

$consultpress_blog_id = absint( get_option( 'page_for_posts' ) );

?>

<div class="header__page-header  page-header">
	<?php
	$consultpress_main_tag = 'h1';
	$consultpress_subtitle = false;

	if ( is_home() || ( is_single() && 'post' === get_post_type() ) ) {
		$consultpress_title    = 0 === $consultpress_blog_id ? esc_html__( 'Blog', 'consultpress-pt' ) : get_the_title( $consultpress_blog_id );
		$consultpress_subtitle = get_field( 'subtitle', $consultpress_blog_id );

		if ( is_single() ) {
			$consultpress_main_tag = 'h2';
		}
	}
	elseif ( is_category() || is_tag() || is_author() || is_post_type_archive() || is_tax() || is_day() || is_month() || is_year() ) {
		$consultpress_title = get_the_archive_title();
	}
	elseif ( is_search() ) {
		$consultpress_title = esc_html__( 'Search Results For' , 'consultpress-pt' ) . ' &quot;' . get_search_query() . '&quot;';
	}
	elseif ( is_404() ) {
		$consultpress_title = esc_html__( 'Error 404' , 'consultpress-pt' );
	}
	else {
		$consultpress_title    = get_the_title();
		$consultpress_subtitle = get_field( 'subtitle' );
	}

	?>

	<?php printf( '<%1$s class="page-header__title">%2$s</%1$s>', tag_escape( $consultpress_main_tag ), wp_kses_post( $consultpress_title ) ); ?>

	<?php if ( $consultpress_subtitle ) : ?>
		<p class="page-header__subtitle"><?php echo esc_html( $consultpress_subtitle ); ?></p>
	<?php endif; ?>
</div>
