<?php

function cnb_admin_header_get_cloud_error($error) {
    $url = admin_url('admin.php');
    $redirect_link =
        add_query_arg(
            array(
                'page' => 'call-now-button-settings',
            ),
            $url );
    $redirect_url = esc_url( $redirect_link );
    $errorNotice = '<div class="notice notice-error">
            <h2 class="title">API Key invalid</h2>
            <p>You have enabled Cloud Hosting, but you need a valid API key from CallNowButtom</p>
            <p>Go to <a href="'.$redirect_url.'">Settings</a> for instructions.</p>';
    $errorNotice .= CnbAdminCloud::cnb_admin_get_error_message_details( $error );
    $errorNotice .= '</div>';
    return $errorNotice;
}

function cnb_admin_header( $cnb_options, $cnb_settings, $cnb_cloud_notifications = array(), $cnb_changelog = array() ) {
    echo '<h1 class="wp-heading-inline">';
    do_action( 'cnb_header' );
    do_action( 'cnb_after_header' );
    echo '</h1>';

    echo '<!--## NOTIFICATION BARS ##  -->';

    // Display notification that the button is active or inactive
    if ( $cnb_options['active'] != 1 ) {
        echo '<div class="notice-error notice"><p>The Call Now Button is currently <b>disabled</b>. Change the <i>Button status</i> under <a href="'.admin_url('admin.php?page=call-now-button-settings').'">Settings</a> to enable.</p></div>';
    }

    // Display notification that there's a caching plugin active
    if ( isset( $_GET['settings-updated'] ) ) {
        $cnb_caching_check = cnb_check_for_caching();
        if ( $cnb_caching_check[0] == true ) {
            echo '<div class="notice-error notice"><p><span class="dashicons dashicons-warning"></span> Your website is using a <strong><i>Caching Plugin</i></strong> (' . $cnb_caching_check[1] . '). If you\'re not seeing your button or your changes, make sure you empty your cache first.</p></div>';
        }
    }

    // Show the notifications after updating the cloud
    if ( is_array( $cnb_cloud_notifications ) ) {
        foreach ( $cnb_cloud_notifications as $cnb_cloud_notification ) {
            echo $cnb_cloud_notification;
        }
    }

    // inform existing users about updates to the button
    if ( $cnb_settings['updated'][0] ) {
        echo '<div class="notice-warning notice is-dismissible">';
        $cnb_old_version = $cnb_settings['updated'][1];
        echo '<h3>' . CNB_NAME . ' has been updated!</h3><h4>What\'s new?</h4>';
        // Only on first run after update show list of changes since last update
        foreach ( $cnb_changelog as $key => $value ) {
            if ( $key > $cnb_old_version ) {
                echo '<h3>' . esc_html($key) . '</h3>';
                if ( is_array( $value ) ) {
                    foreach ( $value as $item ) {
                        echo '<p><span class="dashicons dashicons-yes"></span> ' . esc_html($item) . '</p>';
                    }
                } else {
                    echo '<p><span class="dashicons dashicons-yes"></span> ' . esc_html($value) . '</p>';
                }
            }
        }
        echo '</div>';
    }
}
